%------------------------------------------------------------------------------
% File     : SEU485^1 : TPTP v7.4.0. Released v3.6.0.
% Domain   : Set Theory (Binary relations)
% Problem  : In a confluent relation every element has at most one normal form
% Version  : [Nei08] axioms.
% English  :

% Refs     : [BN99]  Baader & Nipkow (1999), Term Rewriting and All That
%          : [Nei08] Neis (2008), Email to Geoff Sutcliffe
% Source   : [Nei08]
% Names    :

% Status   : Theorem
% Rating   : 1.00 v3.7.0
% Syntax   : Number of formulae    :   59 (   0 unit;  29 type;  29 defn)
%            Number of atoms       :  262 (  34 equality; 167 variable)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :  168 (   4   ~;   4   |;  13   &; 129   @)
%                                         (   0 <=>;  18  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  199 ( 199   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   31 (  29   :;   0   =)
%            Number of variables   :   90 (   0 sgn;  42   !;   5   ?;  43   ^)
%                                         (  90   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : Some proofs can be found in chapter 2 of [BN99]
%          : 
%------------------------------------------------------------------------------
%----Include axioms of binary relations
include('Axioms/SET009^0.ax').
%------------------------------------------------------------------------------
thf(confluent_implies_at_most_one_nf,conjecture,(
    ! [R: $i > $i > $o] :
      ( ( confl @ R )
     => ! [X: $i,Y: $i,Z: $i] :
          ( ( ( nfof @ R @ Y @ X )
            & ( nfof @ R @ Z @ X ) )
         => ( Y = Z ) ) ) )).

%------------------------------------------------------------------------------
